//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.14 Page 176
//Title: Energy transferred from the cylinder.
//====================================================
model Ex5_14
extends Modelica.Constants;
//=============
// Parameter Section
//Refer Ex5_13
parameter Real Bip(unit="dimensionless")=3.95"Biot Number for plate"; 
parameter Real Fop(unit="dimensionless")=0.14"Fourier Number for plate";
parameter Real Bic(unit="dimensionless")=1.32"Biot Number for cylinder"; 
parameter Real Foc(unit="dimensionless")=1.26"Fourier Number for cylinder";
parameter Real Rho(unit="kg/m^3")=7933"Density of nickel-steel";
parameter Real cp(unit="kJ/kg.K")=0.46"Specific heat capacity of nickel-steel";
parameter Real ro(unit="cm")=5"Radius of cylinder";
parameter Real Ti(unit="deg C")=530" Initial temperature of the sphere";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real l1(unit="cm")=30"length of cylinder";
//===================
// Variable Section
Real Qi(unit="MJ")"Heat Transfer Rate"; 
Real Q(unit="MJ")"Heat transfer rate";
Real V(unit="m^3")"Volume of the cylinder"; 
Real i"product of Bi no & Fo for plate"; 
Real j"product of Bi no & Fo for cylinder"; 
Real x"Ratio";
Real y"Ratio";
Real l(unit="cm")"";//2*l=30cm is the thickness of flat plate
//==================
// Equation Section
equation
i=(Fop*Bip^2);
j=(Foc*Bic^2);
l=l1/2;
//From  Heisler chart
//(Qp/Qip)=0.25 at i=2.18 & Bip=3.95
//(Qc/Qic)=0.9 at i=2.2 & Bic=1.32
V=(pi*(ro*0.01)^2*2*l*0.01); //cm to m conversion
Qi=Rho*cp*1000*V*(Ti-To1)*10^(-6); // J to MJ conversion //cp converted from kJ to J
//(Q/Qi)=(Qp/Qip)+((Qc/Qic)*(1-(Qp/Qip)))
//(Qp/Qip)=x;
//(Qc/Qic)=y;
x=0.25;
y=0.9;
Q/Qi=x+(y*(1-x));
end Ex5_14;
