//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.15 Page 179
//Title: Temperature of nickel-steel block  at the depth of the 5 cm after 50s.
//====================================================
model Ex5_15
extends Modelica.Constants;
//============================
// Parameter Section 
parameter Real Ti(unit="deg C")=30" Initial temperature of the  block";
parameter Real To1(unit="deg C")=530"Raised temperature";
parameter Real x(unit="cm")=5"depth"; 
parameter Real k(unit="W/m.K")=19"Thermal conductivity of nickel-steel";
parameter Real a(unit="m^2/s")=0.526e-05"Thermal diffusivity";
parameter Real t(unit="s")=50"time";

//===================
// Variable Section
Real T(unit="deg C")"Temperature of block at depth 5cm after 50s";
Real z"constant";
Real i"ratio";
//==================
// Equation Section
equation 
z=(x*0.01)/(2*sqrt(a*t));
//Refer table 5.1 on page 180
//Read the value of   at erf(z)=0.9706       z=x/(2*(a*t)^0.5)=1.54
//(T-To1)/(Ti-To1)=0.9706=i
i=0.9706;
(T-To1)/(Ti-To1)=i;
end Ex5_15;
