//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.16 Page 181
//Title: Time required to reach x temperature ,Energy transferred.
//====================================================
model Ex5_16
extends Modelica.Constants;
//============================
// Parameter Section 
parameter Real Ti(unit="deg C")=375" Initial temperature of the  slab";
parameter Real Tamb(unit="deg C")=75"Temperature of environment";
parameter Real x(unit="cm")=5"depth"; 
parameter Real k(unit="W/m.K")=59"Thermal conductivity of carbon steel";
parameter Real a(unit="m^2/s")=1.626e-05"Diffusivity";
parameter Real T(unit="deg C")=273"Temperature of slab at depth 5cm";
//===================
// Variable Section

Real Q(unit="MJ/m^2")"Heat transfer rate"; 
Real t(unit="s")"Time taken to reach 275 deg C";
Real A(unit="m^2")"Area";
Real j"Ratio";
 //==================
// Equation Section
equation 
//(T-Tamb)/(Ti-Tamb)=erf(x/(2*(a*t)^0.5))=j;
j=(T-Tamb)/(Ti-Tamb);           //Refer eq.5.99 on page 178
//Refer table 5.1 on page 180
//Read the value of z=x/(2*(a*t)^0.5)=0.685  at erf(z)=0.6667
(x*0.01)/(2*(a*t)^0.5)=0.685;
A=1;   
Q/A=2*k*(Tamb-Ti)*sqrt(t/(pi*a))*10^(-6);  //Refer eq.5.104 on page 179
end Ex5_16;
