//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.17 Page 182
//Title: Temperature of iron block at depth 5cm after a time of 50s.
//====================================================
 model Ex5_17
 extends Modelica.Math.Special;
extends Modelica.Constants;
//============================
// Parameter Section 
parameter Real Ti(unit="deg C")=30"Initial temperature of the  block";
parameter Real qo(unit="MW/m^2")=2"Heat flux";
parameter Real x(unit="cm")=5"depth"; 
parameter Real k(unit="W/m.K")=59"Thermal conductivity of wrought-iron";
parameter Real a(unit="m^2/s")=1.626e-05"Thermal diffusivity";
parameter Real t(unit="s")=50"Time";
parameter Real A(unit="m^2")=1"Area";
//===================
// Variable Section
Real T(unit="deg C")"Temperature of iron at depth 5cm after 50s";
//==================
// Equation Section
equation
//Temperature distribution of solid is given by
(T-Ti)=(2*qo*10^6*sqrt((a*t)/pi)/(k*A))*exp(-((x*0.01)^2/(4*a*t)))-(((qo*10^6*x*0.01)/(k*A))*(1-erf((x*0.01)/(2*sqrt(a*t)))));//Refer eq.5.108 on page 182// x cm to m conversion// MW to W conversion
end Ex5_17;
