//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.18 Page 183
//Title: Temperature of block  at depth x.
//==================================================== 
model Ex5_18
extends Modelica.Math.Special;
//=============
// Parameter Section 
parameter Real k(unit="W/m.K")=59" Thermal conductivity of wrought-iron";
parameter Real a(unit="m^2/s")=1.626e-5" Thermal diffusivity";
parameter Real x(unit="cm")=5"depth";
parameter Real t(unit="s")=60"time";
parameter Real Ti(unit="deg C")=30" Initial temperature of the sphere";
parameter Real To1(unit="deg C")=530"Temperature of environment";
parameter Real h(unit="W/m^2.K")=400"convective coefficient";
//===================
// Variable Section
Real l"constant";
Real m"constant";
Real i"Dimensionless temperature ratio";
Real T[2](each unit="deg C")"Temperature of block at depth 5cm";//T[1] is the temperature of the block  obtained using graph,T[2] is the temperature of the block obtained by using equation eq. 5.110 on page 183.
//==================
// Equation Section
equation  
(T[2]-Ti)/(To1-Ti)=1-erf(x*0.01/(2*sqrt(a*t)))-((1-erf(x*0.01/(2*sqrt(a*t))+(h*sqrt(a*t))/k))*exp((h*x*0.01/k)+(h^2*a*t)/k^2));
((x*0.01)/(2*sqrt(a*t)))=l;
(h*sqrt(a*t))/k=m;
//From fig. 5.24 we read that (T-Ti)/(To1-Ti)=0.034 which is equal to i at (x/(2*srqt(a*t)))=0.80 & ((h*sqrt(a*t))/k)=0.212;
i=0.034;
(T[1]-Ti)/(To1-Ti)=i;
end Ex5_18;
