 //Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.19 Page 185
//Title:Time required for the temperature to reach 130 deg C at depth of 5cm.
//==================================================== 
model Ex5_19
extends Modelica.Math.Special;
//=============
// Parameter Section 
parameter Real k(unit="W/m.K")=59" Thermal conductivity of wrought-iron";
parameter Real a(unit="m^2/s")=1.626e-5" Thermal diffusivity";
parameter Real x(unit="cm")=5"depth";
parameter Real T(unit="deg C")=130"Temperature of block at depth 5cm";
parameter Real Ti(unit="deg C")=30" Initial temperature of the sphere";
parameter Real To1(unit="deg C")=530"Temperature of environment";
parameter Real h(unit="W/m^2.K")=400"convective coefficient";
//===================
// Variable Section
Real t(unit="s")"time required for the temperature to reach 130deg C";
//==================
// Equation Section
equation
(T-Ti)/(To1-Ti)=(1-erf((x*0.01)/(2*sqrt(a*t)))-((1-erf((x*0.01)/(2*sqrt(a*t))+(h*sqrt(a*t))/k)))*exp(((h*x*0.01)/k)+(h^2*a*t)/k^2));//Refer eq. 5.110 on page 183.
end Ex5_19;
//Remarks 
//The ans given in the book is an approximate answer(290s) but the actual answer is 317.814s calculated by the above equation.
