//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.2 Page 137
//Title: Temperature of wire Biot number.
//==================================================== 
model Ex5_2
//=============
// Parameter Section
parameter Real k(unit="W/m.K")=22.7 "Thermal conductivity of Constantan";
parameter Real d(unit="m")=0.001"Diameter of the wire";
parameter Real To(unit="deg C")=25"Initial temperature of the wire";
parameter Real T(unit="deg C")=225" Final temperature of the wire";
parameter Real To1(unit="deg C")=250"Temperature of air";
parameter Real h(unit="W/m^2.K")=3"Convective coefficient";
parameter Real a(unit="m^2/s")=0.612e-5"Thermal diffusivity";
//===================
// Variable Section
Real t(unit="min")"Time taken by the ball to reach 225 deg C";
Real l(unit="m")"characteristic length";
Real Bi(unit="dimensionless")"Biot Number";
Real Fo(unit="dimensionless")"Fourier Number";
Real r(unit="m")"Radius of wire";
equation
r=d/2;
l=r/2;
Bi=(h*l)/k;                                     //Refer eq.5.1 on page 132
log((T-To1)/(To-To1))=(-Bi)*Fo;                //Refer eq.5.11 on page 134
Fo=(a*t*60)/(l^2);//time-s to min conversion    //Refer eq.5.9 on page 134
end Ex5_2;
