//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.3 Page 151
//Title: Heat Transfer Rate,Time
//==================================================== 
model Ex5_3
//=============
// Parameter Section 
parameter Real k(unit="W/m.K")=0.69"Thermal conductivity of brick wall";
parameter Real To(unit="deg C")=270"Final  temperature of the insulated surface";
parameter Real Ti(unit="deg C")=30" Initial temperature of the wall";
parameter Real To1(unit="deg C")=630"Temperature of hot gases";
parameter Real h(unit="W/m^2.K")=20"Convective coefficient";
parameter Real c(unit="kJ/kg.K")=0.84"Specific heat capacity of brick wall";
parameter Real Rho(unit="kg/m^3")=1600"Density of  brick wall";
parameter Real a(unit="m^2/s")=5.2e-7"Thermal diffusivity";
parameter Real l(unit="m")=0.25"Thickness of brick";
parameter Real Fo(unit="")=0.35"Fourier number";//From graph(page no:152 at (1/Bi)=0.138 and T1=0.6
//===================
// Variable Section
Real T1(unit="")"Dimensionless temperature ratio";
Real Bi(unit="dimensionless")"Biot Number";
Real t(unit="h")"Time taken by the ball to reach 270 deg C";
Real Q(unit="MJ")"Heat transfer rate";
Real Qi(unit="MJ")"Heat Transfer Rate";
//equation section
equation
Bi=(h*l)/k;                  //Refer eq.5.1 on page 132
T1=(To-To1)/(Ti-To1);        //Dimensionless temperature ratio
Fo=(a*t*3600)/(l^2);              //Refer eq.5.9 on page 134
Qi=(c*Rho*2*l*1000*(Ti-To1)*(-1))*10^(-6);// minus sign indicates heat transfer from hot gases to brick 
//Qi-J to MJ conversion//Refer equation 5.76 on page no 148
Q=Qi*0.22;
end Ex5_3;
