//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.4 Page 154
//Title: Temperature at location x in plate, Energy lost per unit area.
//====================================================
model Ex5_4
 //=============
//Parameter Section 
//From Table A1
 parameter Real k(unit="W/m.K")=73"Thermal conductivity of iron";
 parameter Real Rho(unit="kg/m^3")=7897"Density of  iron";
 parameter Real a(unit="m^2/s")=2.034e-5"Thermal diffusivity";
 parameter Real c(unit="kJ/kg.K")=0.452"Specific heat capacity of iron";
 parameter Real Ti(unit="deg C")=800"Initial temperature of the plate";
 parameter Real To1(unit="deg C")=0"Temperature of the environment";
 parameter Real h(unit="W/m^2.K")=50"Convective coefficient";
 parameter Real t(unit="s")=100"time";
 parameter Real x(unit="m")=0.04"depth";
 parameter Real l(unit="m")=0.05"thickness";
//===================
// Variable Section
Real Bi(unit="dimensionless")"Biot Number";
Real Fo(unit="")"Fourier Number";
Real m(unit="")"x/l ratio";
Real j(unit="")"product of Fo & Bi^2";
Real Q(unit="MJ")"Heat transfer rate";
Real Qi(unit="MJ")"Heat Transfer Rate";
Real T(unit="deg C")"Temperature of the iron plate at depth of 4cm after 100s";
//==================
// Equation Section
equation
Bi=(h*l)/k;                    //Refer eq.5.1 on page 132
Fo=(a*t)/(l^2);                //Refer eq.5.9 on page 134
m=x/l;
//Refer figure 5.9 on page 151
//T1=(To-To1)/(Ti-To1)=0.92 at (1/Bi)=29.2 and Fo=0.814
//Refer figure 5.10
//T11=(T-To1)/(To-To1)=0.9 at (1/Bi)=29.2 and Fo=0.814
//T-To1=((T-To1)/(To-To1))*((To-To1)/(Ti-To1))*(Ti-To1)
(T-To1)/(Ti-To1)=0.9*0.92;
 //calculating Fo*Bi^2;
j=Fo*Bi^2;
//Read the value of Q/Qi at j=9.4e-04 and Bi=0.034
//Q/Qi=0.02
Qi=c*1000*Rho*2*l*(Ti-To1)*10^(-6);// Refer equation 5.76 on page 148
//kJ to J //J to MJ conversion
Q=0.02*Qi;
end Ex5_4;
