//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.5 Page 155
//Title: Time required for temperature drop
//==================================================== 
model Ex5_5
//=============
//Parameter Section
//From Table A1
parameter Real k(unit="W/m.K")=204"Thermal conductivity of aluminium";
parameter Real Rho(unit="kg/m^3")=2707"Density of  aluminium";
parameter Real a(unit="m^2/s")=8.418e-5"Thermal diffusivity";
parameter Real c(unit="kJ/kg.K")=0.896"Specific heat capacity of aluminium";
parameter Real h(unit="W/m^2.K")=1000"Convective coefficient";
parameter Real Ti(unit="deg C")=350"Initial temperature of the plate";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real To(unit="deg C")=126"Centre line temperature";
parameter Real l(unit="m")=0.1"Thickness";
//===================
// Variable Section
Real T(unit="")"Dimensionless temperature ratio";
Real t(unit="min")"time";
Real Bi(unit="dimensionless")"Biot Number";
//==================
// Equation Section
equation
T=(To-To1)/(Ti-To1);     //Dimensionless temperature ratio
Bi=(h*l/k);
//Refer figure 5.9 on page 151
// Fo=3 at (1/Bi =2.04 and (To-To1)/(Ti-To1)=0.3)
//Fo=a*t/l^2=3
t=(3*l^2)/(a*60);     //time taken to reach 126 deg C
end Ex5_5;
