//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.6 Page 156
//Title: Time required for temperature drop for a cylinder
//==================================================== 
model Ex5_6
//=============
// Parameter Section 
parameter Real k(unit="W/m.K")=204"Thermal conductivity of aluminium";
parameter Real a(unit="m^2/s")=8.418e-5"Thermal diffusivity";
parameter Real c(unit="kJ/kg.K")=0.896"Specific heat capacity of aluminium";
parameter Real h(unit="W/m^2.K")=1000"Convective coefficient";
parameter Real Ti(unit="deg C")=350" Initial temperature of the cylinder";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real To(unit="deg C")=126"Centre line temperature";
parameter Real ro(unit="m")=0.1"radius of cylinder";
//===================
// Variable Section
Real T"Dimensionless temperature ratio";
Real t(unit="s")"Time taken by the cylinder to reach 126deg C";
Real Bi(unit="dimensionless")"Biot Number";
//equation section
equation
T=(To-To1)/(Ti-To1);     //Dimensionless temperature ratio
Bi=(h*ro/k);             //Biot no for cylinder
//Refer figure 5.12 on page 157
// Fo=3 at (1/Bi =2.04 and (To-To1)/(Ti-To1)=0.3)
//Fo=a*t/l^2
t=(1.55*ro^2)/a;         //time taken to reach 126 deg C
end Ex5_6;
