//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.7 Page 158
//Title: Temperature ,Heat transferred per unit length
//====================================================
model Ex5_7
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real Ro(unit="kg/m^3")=2707"Density of aluminium";
parameter Real k(unit="W/m.K")=204"Thermal conductivity of aluminium";
parameter Real a(unit="m^2/s")=8.418e-5"Thermal diffusivity";
parameter Real cp(unit="kJ/kg.K")=0.896"Specific heat capacity of aluminium";
parameter Real h(unit="W/m^2.K")=600"convective coefficient";
parameter Real Ti(unit="deg C")=350" Initial temperature of the cylinder";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real ro(unit="m")=0.1"radius of cylinder";
parameter Real r(unit="m")=0.06"Radius at which temperature is calculated";
parameter Real t(unit="s")=120"time";
parameter Real l(unit="m")=1"length of the cylinder";
 //===================
// Variable Section
Real T(unit="deg C")" Temperature at r=6cm";
Real Bi(unit="dimensionless")"Biot Number"; 
Real Fo(unit="dimensionless")"Fourier Number";
Real j"Dimensionless number";
Real Qi(unit="MJ")"Heat Transfer Rate"; 
Real Q(unit="MJ/m")"Heat transfer rate per unit length of the cylinder";
Real x"ratio";
Real y"ratio";
//equation section
equation
Bi=h*ro/k;
Fo=a*t/ro^2;
 //Refer figure 5.13 on page 158
//(To-To1)/(Ti-To1)=0.65 which is equal to x at Fo=1.01 and (1/Bi)=3.4
//(T-To1)/(To-To1)=0.93 which is equal to y at (1/Bi)=3.04 and r/ro=0.6
//T-To1=((T-To1)/(To-To1))*((To-To1)/(Ti-To1))*(Ti-To1)
x=0.65;
y=0.93;
(T-To1)/(Ti-To1)=x*y;
//Calculate Fo*bi^2
j=(Fo*Bi^2);
//Refer fig.5.15 on page 160
//Q/Qi=0.38 at Fo*Bi^2=0.087 and Bi=0.294
(Qi/l)=Ro*cp*1000*pi*ro^2*(Ti-To1)*10^(-6);// J to MJ conversion //cp converted from kJ to J Qi per unit length l=1   therefore Qi/l=Qi;
Q=0.38*Qi;
end Ex5_7;
