//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.8 Page 161
//Title: Time required for temperature drop
//====================================================
model Ex5_8
//=============
// Parameter Section 
parameter Real h(unit="W/m^2.K")=500"convective coefficient";
parameter Real Ti(unit="deg C")=630" Initial temperature of the sphere";
parameter Real To1(unit="deg C")=30"Temperature of oil bath";
parameter Real ro(unit="m")=0.1"radius of sphere";
parameter Real To(unit="deg C")=90"Centre line temperature";
parameter Real a(unit="m^2/s")=1.474*10^(-5)"Thermal diffusivity";
parameter Real k(unit="W/m.K")=54"Thermal conductivity of steel";
//===================
// Variable Section 
Real T1(unit="")"Dimensionless temperature ratio";
Real Bi(unit="dimensionless")"Biot Number";
Real t(unit="h")"Time taken by the sphere  to reach 90 deg C";

//equation section
equation
T1=(To-To1)/(Ti-To1);      //Dimensionless temperature ratio
Bi=(h*ro/k);
//From fig. 5.17 Fo=1.125 where Fo=a*t/ro^2 at (To-To1)/(Ti-To1)=0.1 and (1/Bi)=1.08
(a*t*3600)/(ro^2)=1.125;
end Ex5_8;
//Remarks 
//The value t  given in the book is 7632s which is equal to 2.12h but the actual ( Calculated) value of t from the final equation is 763.2s which is equal to 0.212 h 
