//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.9 Page 163
//Title: Temperature at location x in plate,amount of  heat transferred
//====================================================
model Ex5_9
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real Rho(unit="kg/m^3")=7833"Density of steel";
parameter Real k(unit="W/m.K")=54"Thermal conductivity of steel";
parameter Real a(unit="m^2/s")=1.474e-5"Thermal diffusivity";
parameter Real cp(unit="kJ/kg.K")=0.465"Specific heat capacity of steel";
parameter Real h(unit="W/m^2.K")=500"convective coefficient";
parameter Real Ti(unit="deg C")=325" Initial temperature of the sphere";
parameter Real To1(unit="deg C")=25"Temperature of environment";
parameter Real ro(unit="m")=0.06"radius of cylinder";
parameter Real r(unit="m")=0.036"Radius at which temperature is calculated";
parameter Real t(unit="s")=100"time";

//===================
// Variable Section
Real Bi(unit="dimensionless")"Biot Number"; 
Real Fo(unit="dimensionless")"Fourier Number";
Real T(unit="deg C")" Temperature at r=3.6cm & t=100s";
Real j"Dimensionless number";
Real Qi(unit="MJ")"Heat Transfer Rate"; 
Real Q(unit="MJ")"Heat transfer rate";
Real x"ratio";
Real y"ratio";
//==================
// Equation Section
equation
Bi=h*ro/k;
Fo=a*t/ro^2;
//From fig. 5.17
//(T-To1)/(Ti-To1)=0.7 at Fo=0.409 and 1/Bi=1.8
//(T-To1)/(To-To1)=0.9 at (1/Bi)=1.8 and r/ro=0.6
//T-To1=((T-To1)/(To-To1))*((To-To1)/(Ti-To1))*(Ti-To1)
x=0.7;
y=0.9;
(T-To1)/(Ti-To1)=x*y;
j=(Fo*Bi^2);
//Refer fig.5.19 on page 165
//Q/Qi=0.45 at Fo*Bi^2=0.126 and Bi=0.555
Qi=Rho*cp*1000*(4/3)*pi*ro^3*(Ti-To1)*10^(-6);// Qi-J to MJ conversion //cp converted from kJ to J
Q=Qi*0.45;
end Ex5_9;
