//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-7:Radiation heat transfer
//Example: 7.1 Page 251
//Title: Percentage of solar radiation emitted
//====================================================
model Ex7_1
//=============
// Parameter Section
parameter Real T(unit="K")=5800"Temperature of the black body";
parameter Real lamda1(unit="mum")=0.35"wavelength";
parameter Real lamda2(unit="mum")=2.7"wavelength";
parameter Real Tr=0.92"percentage transmittivity";
final constant Real sigma(final unit="W/m^2.K^4")=5.669*10^(-8)"Stefan-Boltzmann constsnt";
//===================
// Variable Section
Real i;
Real j;
Real Rp"Rercentage radiation transmitted by the window glass";
Real k"percent radiation in the range 0.35 to 2.7mum";
Real Ebo_in"Energy radiated per unit area and per unit time";
Real x"Ebo-lamdaT/sigma*T^4 value at lamda2*T=15660mum K";
Real y"Ebo-lamdaT/sigma*T^4 value at lamda1*T=2030mum K";
//==================
// Equation Section
equation
i=lamda1*T;
j=lamda2*T;
//From table 7.1  Ebo-lamdaT/sigma*T^4 values at (lamda1*T)i=2030mum.K and (lamda2*T)j=15660mum.K are 0.07165 & 0.97176
y=0.07165;
x=0.97176;
k=(x-y)*100;
Rp=Tr*k;
(Ebo_in)=sigma*T^4*10^(-6);
end Ex7_1;
