//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-7:Radiation heat transfer
//Example: 7.10 Page 272
//Title: Radiation heat transfer rate
//====================================================
 model Ex7_10
//==================
// Parameter Section
parameter Real Tp1(unit="K")=1200"Temperature of plate 1";
parameter Real Tp2(unit="K")=600"Temperature of plate 2";
parameter Real l(unit="m")=1"length of the plate ";
parameter Real w(unit="m")=0.5"Width of the plate";
parameter Real D(unit="m")=0.5"Distances between the plates";  
parameter Real Tr(unit="K")=300"Temperature of the room";
final constant Real sigma(final unit="W/m^2.K^4")=5.669*10^(-8)"Stefan-Boltzmann constsnt";
 //===================
// Variable Section
Real i"ratio";
Real j"ratio";
Real F12 "Shape factor"; Real F21 "Shape factor";Real F13 "Shape factor"; Real F23 "Shape factor";
Real A1(unit="m^2")"Area of plate 1";
Real A2(unit="m^2") "Area of plate 2";
Real Eb1(unit="kW/m^2")"emissive power of plate 1";
Real Eb2(unit="kW/m^2")"emissive power of plate 2";
Real Eb3(unit="kW/m^2")"emissive power of plate 3";
Real R1(unit="m^(-2)")"Resistance to heat flow for plate 1 & 2";
Real R2(unit="m^(-2)")"Resistance to heat flow for plate 1 & room";
Real R3(unit="m^(-2)")"Resistance to heat flow for plate 2 & room";
Real q1(unit="kW")"Hat transfer from plate 1";
Real q2(unit="kW")"Heat transfer rate from plate 2";
Real q3(unit="kW")"Total heat received by the room";
//==================
// Equation Section
equation
//Refer Fig. 7.24 for equivalent circuit for the problem
i=w/D;
j=l/D;
//from Fig.7.8 F12=0.29 at i=1 j=2
F21=0.29;
F12=F21;
F12+F13=1;         //Energy conservation principle
F21+F23=1;
(A1)=(l*w); //Are =l*w
(A2)=A1;
//Space radiation resistances
R1=1/(A1*F12);  //Refer eq.7.35 on page 271
R2=1/(A1*F13);
R3=1/(A1*F23);
//W/m^2 to kW/m^2 conversion
//Refer eq.7.8 on page 249
Eb1=sigma*(Tp1)^4*0.001;
Eb2=sigma*(Tp2)^4*0.001;
Eb3=sigma*(Tr)^4*0.001;
//Emissive power and heat transfer rate are related by
q1=((Eb1-Eb2)/R1)+(Eb1-Eb3)/R2;
q2=((Eb2-Eb1)/R1)+(Eb2-Eb3)/R2;
q3=((Eb1-Eb3)/R2)+(Eb2-Eb3)/R3;
end Ex7_10;
