//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-7:Radiation heat transfer
//Example: 7.11 Page 278
//Title: Radiation heat transfer rate.
//====================================================
 model Ex7_11
 //==================
// Parameter Section
parameter Real epi1=0.5"emissivity of plate 1";
parameter Real epi2=0.5"emissivity of plate 2";
parameter Real A1(unit="m^2")=0.5"Area of plate 1";
parameter Real A2(unit="m^2")=0.5"Area of plate 2";
Real F12=0.29 "Shape factor";Real F13=0.71 "Shape factor"; Real F23=0.71 "Shape factor";
//===================
// Variable Section
Real Eb1(unit="kW/m^2")"emissive power of plate 1";
Real Eb2(unit="kW/m^2")"emissive power of plate 2";
Real Eb3(unit="kW/m^2")"emissive power of plate 3";
Real R1(unit="m^(-2)")"Surface Resistance ";
Real R2(unit="m^(-2)")"Surface Resistance ";
Real R3(unit="m^(-2)")"Resistance";
output Real J1(unit="kW/m^2")"Radiosity 1";
output Real J2(unit="kW/m^2")"Radiosity 2";
Real q1(unit="kW")"Heat lost by the plate 1";
Real q3(unit="kW")"Heat received by the room";
//==================
// Equation Section
equation 
//Refer example 7.10 for Eb values.
//Refer eq.7.8 on page 249
Eb1=117.552;
Eb2=7.347;
Eb3=0.459;
//radiation resistances
R1=(1-epi1)/(A1*epi1);
R2=(1-epi2)/(A2*epi2);
R3=0;     //Since A3 is very large R3 =0; //J3=Eb3;
//Solving these two equations we get the value of J1 & J2 
(((Eb1-J1)*1000)/R1)+(((J2-J1)*1000)/(1/(A1*F12)))+(((Eb3-J1)*1000)/(1/(A1*F13)))=0;
((J1-J2)*1000/(1/(A1*F12)))+((Eb2-J2)*1000/(R2))+((Eb3-J2)*1000/(1/(A2*F23)))=0;
q1=((Eb1)-J1)/(R1);
q3=((J1-Eb3)/(1/(A1*F13)))+((J2-Eb3)/(1/(A2*F23)));
end Ex7_11;
