//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-7:Radiation heat transfer
//Example: 7.12 Page 280
//Title: Radiant heat transfer when shielded.
//====================================================
model Ex7_12
extends Modelica.Constants;
//The surface are treated as grey surfaces.
//Refer fig.7.29 on page 280 for circuit diagram
//==================
// Parameter Section
parameter Real Ts1(unit="K")=4.2"Temperature of inner sphere";
parameter Real Ts2(unit="K")=300"Temperature of outer sphere";
parameter Real ID(unit="m")=0.48"Inner diameter ";
parameter Real OD(unit="m")=0.5"Outer diameter";
parameter Real epi1=0.05"emissivity of outer surface of the inner sphere";
parameter Real epi2=0.05"emissivity of inner surface of the outer sphere";
parameter Real lamda(unit="J/mol")=83.3"latent heat of vaporization of Helium";
Real F12=1 "Shape factor";

//===================
// Variable Section
Real A1(unit="m^2")"Area of  inner sphere";
Real A2(unit="m^2") "Area of outer sphere";
Real Eb1(unit="W/m^2")"emissive power of inner sphere";
Real Eb2(unit="W/m^2")"emissive power of outer sphere";
Real R1(unit="m^(-2)")"Surface resistance to radiation";
Real R2(unit="m^(-2)")"Surface resistance to radiation";
Real R12(unit="m^(-2)")"Space resistance to radiation";
Real Rt(unit="m^(-2)")"Total Resistance to radiation";
Real q(unit="W")"Heat Transfer Rate";
Real m(unit="g/s")"Rete of evaporation of Helium";
//==================
// Equation Section
equation 
//Inner sphere
A1=4*pi*(ID/2)^2; //Area
Eb1=sigma*Ts1^4; //emissive power
R1=(1-epi1)/(epi1*A1);
//For outer sphere
A2=pi*OD^2;
//Refer eq.7.8 on page 249
Eb2=sigma*Ts2^4;
R2=(1-epi2)/(epi2*A2);
R12=1/(A1*F12);        //space resistance
Rt=R1+R12+R2;         //Total resistance in series
q=(Eb1-Eb2)/Rt;
//Q=m*lamda
m=((-q)*4)/lamda; //multiply by molar mass =4g/mol.
end Ex7_12;
