//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-7:Radiation heat transfer
//Example: 7.4 Page 262
//Title: Net radiant heat exchange.
//====================================================
 model Ex7_4
//==================
// Parameter Section
parameter Real Tp1(unit="deg C")=800"Temperature of plate 1";
parameter Real Tp2(unit="deg C")=200"Temperature of plate 2";
parameter Real l(unit="m")=1"length";
parameter Real w(unit="m")=2"Width";
parameter Real D(unit="m")=1"Distances between the plates"; 
final constant Real sigma(final unit="W/m^2.K^4")=5.67*10^(-8)"Stefan-Boltzmann constsnt";
//===================
// Variable Section
 Real x(unit="m")"length of divided plate";
 Real y(unit="m")"width of divided plate";
 Real F12 "Shape factor";
 Real i"ratio";
 Real j"ratio";
 Real qnet(unit="kW") "Radiant heat Transfer Rate ";
 Real A1(unit="m^2")"Area";
//==================
// Equation Section
equation
A1=l*w;
x=1;
y=2;
i=x/D;
j=y/D;
//from Fig.7.8 F12=0.29 at i=1 j=2
F12=0.29;
//qnet=A1*F12*(Eb1-Eb2)
qnet=A1*F12*sigma*((Tp1+273)^4-(Tp2+273)^4)*0.001; //Refer eq. 1.9 on page 10 //deg C to K conversion//W to kW conversion
end Ex7_4;
