//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.1
//Title:Mixture of ideal gas
//Determine molar mass of fuel and gravimetric analysis
package Ex10_1

model Ex10_1_a

//=================
//parameter section
parameter Real N1(unit="%")=40"% of CH4 in fuel";
parameter Real N2(unit="%")=20"% of C2H6 in fuel";
parameter Real N3(unit="%")=25"% of H2 in fuel";
parameter Real N4(unit="%")=15"% of N2 in fuel";
parameter Real M1(unit="kg/kmol")=16"Molecular weight of CH4";
parameter Real M2(unit="kg/kmol")=30"Molecular weight of C2H6";
parameter Real M3(unit="kg/kmol")=2"Molecular weight of H2";
parameter Real M4(unit="kg/kmol")=28"Molecular weight of N2";

//================
//Variable section
Real M(unit="kg/kmol")"Molar mass of the mixture";

//==================
    //equation section
  equation
M=(N1*M1/100)+(N2*M2/100)+(N3*M3/100)+(N4*M4/100);
end Ex10_1_a;

//====================
model Ex10_1_b
extends Ex10_1_a;

//====================
//variable section
Real m(unit="kg")"mass of the mixture";
Real yCH4(unit="dimensionless")"mass fraction of CH4";
Real yC2H6(unit="dimensionless")"mass fraction of C2H6";
Real yH2(unit="dimensionless")"mass fraction of H2";
Real yN2(unit="dimensionless")"mass fraction of N2";

//==================
//equation section
equation
m=((M1*N1)+(M2*N2)+(M3*N3)+(M4*N4))/1000;
yCH4=(M1*N1)/(1000*m);//To calculate mass fraction of each component
yC2H6=(M2*N2)/(1000*m);
yH2=(M3*N3)/(1000*m);
yN2=(M4*N4)/(1000*m);
end Ex10_1_b;


end Ex10_1;
