//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.10
//Title:Air-Conditioning
//Determine state of resulting mixture 

model Ex10_10

//=====================
//parameter section
parameter Real V1(unit="m^3/min")=10"volumetric flow rate of air initially";
parameter Real P(unit="atm")=1"Pressure of the air";
parameter Real T1(unit="deg C")=20"Temperature of the air initially";
parameter Real T2(unit="deg C")=40"Temperature of the air finally";
parameter Real si1(unit="%")=90"Relative humidity initially";
parameter Real si2(unit="%")=20"Relative humidity finally";
parameter Real V2(unit="m^3/min")=30"volumetric flow rate of air finally";
//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//====================
//variable section
Real Ps(unit="kPa")"saturation pressure initially";
Real pw(unit="kPa")"partial pressure of water vapor";
Real w1(unit="kg water/kg dry air")"specific humidity initially";
Real y1(unit="dimensionless")"mole fracton of water";
Real v1(unit="m^3/kmol")"volume of the mixture";
Real y2(unit="dimensionless")"mole fraction of water vapor";
Real v2(unit="m^3/kmol")"volume of water vapor";
Real ma1(unit="kg/min")"flow rate of dry air in kg/min in the first case";
Real ma2(unit="kg/min")"mass flow rate of dry air kg/min in the second case";
Real w2(unit="kg water/kg dry air")"specific humidity in the second case";
Real w3(unit="kg water/kg dry air")"specific humidity in the final case";
Real h1(unit="kJ/kg dry air")"enthalpy initially";
Real h2(unit="kJ/kg dry air")"enthalpy in the second case";
Real h3(unit="kJ/kg dry air")"enthalpy in the final case";
Real pw1(unit="kPa")"partial pressure of water vapor";
Real Fda1(unit="kmol/min")"flow rate of dry air in kmol/min in first case";
Real Fda2(unit="kmol/min")"flow rate of dry air in kmol/min in second case";

//==================
//equation section
equation
//Refer to book Pg no:411 for the value of Ps
Ps=2.337;
si1/100=pw/Ps;
w1=0.622*(pw/(101.325-pw));
y1=pw/(P*101.325);//multiplied by 101.325 to convert atm to kPa
v1=(R*1000*(T1+273))/(P*101.325*1000);
Fda1=(V1/v1)*0.9792;
ma1=Fda1*28.97;
w2=0.009;//from psychrometric chart
pw1=1.3;
y2=pw1/(P*101.325);
v2=(R*1000*(T2+273))/((P*101.325)*1000);
Fda2=(V2/v2)*(1-y2);
ma2=Fda2*28.97;
ma1/ma2=(w2-w3)/(w3-w1);
h2=64;
h1=54;
ma1/ma2=(h2-h3)/(h3-h1);
//Remarks:Flow rate of dry air is originally Fda2=1.153 kmol/min  but in book given as 0.985 kmol/min.so ma2 value is 33.406 kg/min but in book given as 28.535 kg/min which is error
end Ex10_10;
