//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.4
//Title:Properties of ideal gas mixture
//Predict temperature of gas mixture and evaluate entropy change for each gas
model Ex10_4

//==================
//parameter section
parameter Real N1(unit="%")=25"Amount of nitrogen in the mixture";
parameter Real N2(unit="%")=75"Amount of hydrogen in the mixture";
parameter Real T1(unit="K")=300"Temperature of the mixture";
parameter Real P1(unit="kPa")=100"initial pressure";
parameter Real P2(unit="kPa")=500"final pressure";
parameter Real MW1(unit="kg/kmol")=2.016"Molecular weight of hydrogen";
parameter Real MW2(unit="kg/kmol")=28.013"Molecular weight of nitrogen";

//==================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real Cp1(unit="kJ/kmol.K")"specific heat at constant pressure of nitrogen";
Real Cp2(unit="kJ/kmol.K")"specific heat at constant pressure of hydrogen";
Real Cv1(unit="kJ/kmol.K")"specific heat at constant volume of nitrogen";
Real Cv2(unit="kJ/kmol.K")"specific heat at constant volume of hydrogen";
Real Cp(unit="kJ/kmol.K")"sppecific heat at constant pressure";
Real Cv(unit="kJ/kmol.K")"specific heat at constant volume";
Real gamma(unit="dimensionless")"Ratio of specific heats";
Real T2(unit="K")"final Temperature";
Real M(unit="kg/kmol")"molar mass of mixture";
Real ws(unit="kJ/kmol")"work done per mole";
Real Ws(unit="kJ/kg")"work done per kg";
Real delS1(unit="kJ/kmol.K")"entopy change for hydrogen";
Real delS2(unit="kJ/kmol.K")"entopy change for nitrogen";
Real delS3(unit="kJ/kmol.K")"entopy change for mixture";

//=================
//equation secion
equation
//REfer to book Pg no:396 for the value of Cp1,Cp2,Cv1,Cv2
Cp1=28.6455;
Cp2=29.1783;
Cv1=20.3311;
Cv2=20.8641;
Cp=(N2*Cp1/100)+(N1*Cp2/100);
Cv=(N2*Cv1/100)+(N1*Cv2/100);
gamma=Cp/Cv;
T2=T1*((P2/P1)^((gamma-1)/gamma));
ws=Cp*(T2-T1);
M=(N2*MW1/100)+(N1*MW2/100);
Ws=ws/M;
delS1=(28.6455*log(T2/T1))-(R*log(P2/P1));
delS2=(29.1783*log(T2/T1))-(R*log(P2/P1));
delS3=(N2*delS1/100)+(N1*delS2/100);
//Remarks:Value of delS3 is so small that it is assumed to be 0
end Ex10_4;
