//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.8
//Title:Psychometer
//Determine speciﬁc humidity and relative humidity of air

model Ex10_8

//=================
//parameter section
parameter Real T1(unit="deg C")=40"Temperature of mixture";
parameter Real T2(unit="deg C")=30"Temperature of mixture leaving";
parameter Real P(unit="kPa")=101.325"Pressure of mixture";

//=================
//variable section
Real Ps(unit="kPa")"saturation pressure";
Real w2(unit="kg H2O/kg dry air")"Specific humidity";
Real hfg2(unit="kJ/kg")"specific enthalpy of the mixture";
Real hg1(unit="kJ/kg")"specific enthalpy in the vapor state";
Real hf2(unit="kJ/kg")"specific enthalpy in the liquid state";
Real Cp(unit="kJ/kg.K")"specific heat at constant pressure";
Real w1(unit="kg H2O/kg dry air")"specific humidity of the inlet air";
Real pw(unit="kPa")"Partial pressure of water vapor";
Real Ps2(unit="kPa")"saturation pressure at second temperature";
Real si2(unit="dimensionless")"Relative humidity";

//================
//equation section
//Refer to book Pg no:406 for the value of Ps,Ps1,hfg2,hg1,hf2
equation
Ps=4.241;//Refer to book Pg no:406 for the equation
w2=0.622*(Ps/(P-Ps));
hfg2=2430.74;
hg1=2574.4;
hf2=125.66;
Cp=1.005;
w1=((Cp*(T2-T1))+(w2*hfg2))/(hg1-hf2);
w1=0.622*(pw/(P-pw));
Ps2=7.375;
si2=pw/Ps2;
end Ex10_8;
