//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 10:Gas-vapor mixtures and Psychometry
//Example:10.9
//Title:Psychrometeric chart
//Determine speciﬁc humidity and relative humidity and partial pressure of water vapor and enthalpy of mixture

model Ex10_9

//======================
//parameter section
parameter Real P(unit="atm")=1"Pressure of the moist air";
parameter Real T1(unit="deg C")=40"Temperature when read with psychrometer";
parameter Real T2(unit="deg C")=30"Dry bulb temperature";

//===============
//variable section
Real w1(unit="kg H2O/kg dry air")"specific humidity of the air";
Real si1(unit="dimensionless")"Relative humidity";
Real pw(unit="kPa")"Partial pressure of water vapor";
Real h2(unit="kJ/kg dry air")"enthalpy of the mixture";
Real ha1(unit="kJ/kg dry air")"enthalpy of the liquid";
Real hg1(unit="kJ/kg dry air")"enthalpy of the gas";
Real w2(unit="kg H2O/kg dry air")"specific humidity of the air using psychrometry chart";

//===============
//equation section
equation
w1=0.0229;//Calculated from example Ex:10_8
si1=0.4897;
pw=3.598;
ha1=1.005*40;//Refer to book Pg no:407 for the equation
hg1=2574.4;
h2=ha1+(w1*hg1);
//Refer to psychrometric chart in Pg no:408 for the value of w2
w2=0.0230;
end Ex10_9;
