//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 2:Concepts and definitions
//Example:2.2
//Title:energy
//Calculate the change in kinetic energy of the glider 
//======================

model Ex2_2
//variable section
Real W(unit = "kJ")"work done";
Real Ke(unit="kJ")"kinetic energy" ;

//========================
//parameter section
  parameter Real V1(unit = "km/h") = 0"initial velocity of glider";
  parameter Real V2(unit = "km/h") =60"velocity of glider after it is accelerated"; 
  parameter Real Vf(unit = "km/h") = 10"velocity of glider after its speed is reduced";
  parameter Real m(unit="kg")=150"mass of the glider";
  
//====================
//equation section  
  equation
  W=(m*(((V2*1000/3600)^2)-((V1*1000/3600)^2))/2)*0.001;                //refer page no 22
                                                          
                                                                
  Ke=(m*(((Vf*1000/3600)^2)-((V2*1000/3600)^2))/2)*0.001;         //refer page no 22

end Ex2_2;
