//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 2:Concepts and definitions
//Example:2.4
//Title:work
//Calculate the work done by gas 
//=================
model Ex2_4

//=================
//variable section

Real W(unit="kJ")"work done by the gas";

//================
//parameter section

parameter Real P1( unit="kPa") =200 "initial pressure in which the gas is present";
parameter Real P2( unit="kPa") =500 "final pressure in which the gas is present";
parameter Real V1(unit="m^3") =0.1 "initial volume in which the gas is present";
parameter Real V2(unit="m^3") =0.2 "final volume in which the gas is present";

//===================
//equation section

equation
W=((P1+P2)*(V2-V1))/2;  //refer to page no 34 and 35 for the derivation of this work done 
                        //as P=atm P+spring constant*(v-v0)/(a^2)
end Ex2_4;
