//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.11
//Title:Tabular Representation of data
//Determine 1saturation pressure and latent heat of vaporization at 200 deg C 2 Speciﬁc internal energy of saturated vapor at 200 deg C
package Ex3_11

model Ex3_11_a
//====================
//parameter section
parameter Real T(unit="deg C")=200"Temperature";

//==============
//Variable section
Real P(unit="bar")"saturation pressure";
Real hf(unit="kJ/kg")"specific enthalpy of the saturated liquid";
Real hg(unit="kJ/kg")"specific enthalpy of the saturated vapour";
Real hfg(unit="kJ/kg")"latent heat of vaporization";

//=====================
//equation section
equation
//Refer to steam tables in Appendix Book Pg no:441
//Refer to book Pg no:79
P=15.549;//Absolute pressure in bar from steam table
hf=852.37;//specific enthalpy of the saturated liquid from steam table
hg=2790.9;//specific enthalpy of the saturated vapour from steam table
hfg=hg-hf;

end Ex3_11_a;


//==================================
model Ex3_11_b
extends Ex3_11_a;
  
//===============
//variable section
Real vg(unit="m^3/kg")"specific volume of saturated vapour";
Real ug(unit="kJ/kg")"specific internal energy of saturated vapour";

//==================
//equation section
equation
//Refer to steam tables in Appendix from book Pg no:441
//Refer to book Pg no:79for problem
vg=0.1272;//specific volume of saturated vapour from steam table
ug=((hg*1000)-(P*(10^5)*vg))/1000;

end Ex3_11_b;


end Ex3_11;
