//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.13
//Title:Tabular Representation of data
//Estimate speciﬁc volume and speciﬁc enthalpy

model Ex3_13

//==================
//parameter section
parameter Real P(unit="bar")=32"pressure of the saturated vapour";

//==============
//variable section

Real vg(unit="m^3/kg")"specific volume at the given pressure";
Real hg(unit="kJ/kg")"specific enthalpy at the given pressure";
Real P1(unit="bar")"First pressure for interpolation";
Real P2(unit="bar")"second pressure for interpolation";
Real vg1(unit="m^3/kg")"specific volume at the first pressure";
Real vg2(unit="m^3/kg")"specific volume at the second pressure";
Real hg1(unit="kJ/kg")"specific enthalpy at the first pressure";
Real hg2(unit="kJ/kg")"specific enthalpy at the second pressure";

//===================
//equation section
equation
//Refer to Appendix c in Book Pg no:444 we find the value of only 30 bar and 35 bar.To find the value at 32 bar we have to interpolate
P1=30;
P2=35;
vg1=0.06663;
vg2=0.05703;
hg1=2802.3;
hg2=2802.0;
vg=vg1+((((vg2-vg1)/(P2-P1)))*(P-P1));//Refer to book Pg no:79 fo the equation
hg=hg1+((((hg2-hg1)/(P2-P1)))*(P-P1));
end Ex3_13;
