//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.2
//Title:Other equations of state
//Pressure developed by gas by ideal gas law and vander waals equation and Redlich Kwong equation .
package Ex3_2
model Ex3_2_a

//variable section
Real P1(unit="MPa")"pressure using ideal gas law";
//=========================
//parameter section

parameter Real T(unit="deg C")=200"temperature of steel vessel" ;
parameter Real v(unit="m^3")=0.6"volume of steel vessel";

//constant section

constant Real R(unit="J/K mol")=8.314"gas constant";

//===================
//equation section

equation
P1=(R*(T+273)*1000)/(v*1000*1000);//Temperature converted from deg C to kelvin
                                    //refer to book Pg no:58 for conversion of m^3 to lit
                                    //divided by 1000*1000 to convert to MPa
                                  
end Ex3_2_a;


//============================
model Ex3_2_b
extends Ex3_2_a;

//variable section
Real P2(unit="MPa")"pressure using vander waals equation";
//=====================
//parameter section

parameter Real a(unit="Pa.(m^3/mol)^2)")=453.046*(10^(-3))"value of a in vander waals eqn";
parameter Real b(unit="m^3/mol")=0.057*(10^(-3))"value of b in vander waals wqn";

//=======================
//equation section

equation
P2=(((R*(T+273))/(((v*10^(-3))-b)))-((a/(v*(10^(-3)))^2)))/(1000*1000);        //vander waals equation
                                                                                 //divided by 1000*1000 to convert Pa to MPa  
                                                                                
                                                                                   
end Ex3_2_b;



//=================================
model Ex3_2_c
extends Ex3_2_a;

//variable section
Real P3(unit="MPa")"pressure using Redlich Kwong equation";
Real a(unit="m^6.Pa/mol^2");
Real b(unit="m^3/mol");
//=====================
//parameter section

parameter Real Tc(unit="K")=283.1"critical temperature";
parameter Real Pc(unit="bar")=51.17"critical pressure";

//==============
//equation section
equation
a=0.4274*R^2*Tc^(2.5)/(Pc*(T+273)^0.5*10^5);//temperature converted from degC to K
b=(0.0867*R*Tc)/(Pc*10^5);
P3=((R*(T+273)/((v*0.001)-b))-(a/(v*0.001*(v*0.001+b))))/(1000*1000);       //divided by 1000*1000 to convert Pa to MPa                                                                                               
                                                                                       //divided by 1000*1000 to convert Pa to MPa  
                                                                                       //refer to book for the equation
                                                                                         
end Ex3_2_c;
























end Ex3_2;
