//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.3
//Title:Compressibility Chart
//Determine volume of cylinder for storage 

model Ex3_3

//======================
//variable section
Real Pr(unit="")"Reduced pressure";
Real Tr(unit="")"Reduced temperature";
Real v(unit="m^3/kmol")"volume of cylinder";

//============================
//parameter section
parameter Real P(unit="MPa")=60"pressure";
parameter Real T(unit="K")=300"temperature";
parameter Real n(unit="kmol")=1"number of moles in book considerd as 1";
parameter Real Pc(unit="bar")=46.41"critical pressure";
parameter Real Tc(unit="K")=190.7"critical temperature";
parameter Real Z(unit="dimensionless")=1.34;          //value of compressibility factor can be found out by verifying the graph in book pg no:62 it can be found  by finding reduced pressure and reduced temperature

//=====================
//constant section

constant Real R(unit="J/K mol")=8.314"gas constant";

//=========================
//equation section    
equation                                             

Pr =(P*10^6)/(Pc*10^5) ;              //finding reduced pressure
Tr=T/Tc;              //finding reduced temperature

//find compressibility factor using Pr and Tr using graph in Pg no:62

v=(Z*n*R*10^3*T)/(P*1000*1000);          //refer to book Pg no:62 for equation
                                         //divided by 1000*1000 to convert to m^3/kmol
end Ex3_3;
