//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 3:Thermodynamic properties of fluids
//Example:3.6
//Title:Compressibility Chart
//Determine temperature of ethane in cylinder 

model Ex3_6

//======================
//parameter section

parameter Real V(unit="m^3")=0.1"cylinder volume";
parameter Real m(unit="kg")=7"mass of ethane in cylinder";
parameter Real P(unit="bar")=70"pressure";
parameter Real M(unit="kg/kmol")=30"molecular weight of methane";
parameter Real Tc(unit="K")=305.43"temperature";
parameter Real Pc(unit="MPa")=4.844"pressure";
parameter Real R(unit="J/L.mol")=8.314"gas constant";

//=================
//variable section

Real Pr(unit="dimensionless")"reduced pressure";
Real vr(unit="dimensionless");
Real T(unit="K")"temperature of ethane";
Real n(unit="mol")"number of moles of ethane";
Real Tr(unit="dimensionless");
//=============================
//equation section

equation
Pr=(P*100000)/(Pc*1000000);
n=7/(30/1000);
vr=(Pc*1000000*(V/n))/(8.314*305.43);
Tr=1.4;//Refer to book Pg no:64 and graph in Pg no:65 to find the value of Tr from graph at the intersection of vr and the vertical line from Pr
T=Tr*Tc;
end Ex3_6;
