//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.13
//Title:constant internal energy process
//Compare work required for heating by constant volume followed by cooling at constant pressure and isothermal compression and adiabatic compresssion followed by cooling at constant volume
package Ex5_13

model Ex5_13_a

//===========
//parameter section
parameter Real P1(unit="kPa")=100"pressure at the initial state";
parameter Real P2(unit="kPa")=500"pressure at the final state";
parameter Real T1(unit="deg C")=27"temperature at initial and final conditions";
parameter Real Cv(unit="J/mol.K")=20.93"specific heat at constant volume";
parameter Real Cp(unit="J/mol.K")=29.302"specific heat at constant pressure";

//==============
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
output Real W1(unit="kJ/mol")"work done in the first case";
//Real Pa(unit="kPa")"pressure from the graph";
Real Ta(unit="K")"Temperature for the value from the graph";
Real Va(unit="m^3")"volume";
Real V1(unit="m^3")"volume for the first condition";
Real q1a(unit="kJ/mol")"change in ua and u1";
Real qa2(unit="kJ/mol")"change in enthalpy";
Real delU(unit="kJ/mol")"change in internal energy";

//===================
//equation section
equation
Va=1000;
V1=1000;
Ta=(P2*Va*(T1+273))/(P1*V1);
q1a=(Cv*(Ta-(T1+273)))/1000;
qa2=(Cp*((T1+273)-Ta))/1000;
delU=(Cv*((T1+273)-Ta))/1000;
W1=qa2-delU;
end Ex5_13_a;






//====================

model Ex5_13_b
extends Ex5_13_a;

//=====================
//variable section
output Real W2(unit="kJ/mol")"work done in the second condition";

//===================
//equation section
equation
W2=(R*(T1+273)*log(P1/P2))/1000;//Isothermal compression 

end Ex5_13_b;



//====================

model Ex5_13_c
extends Ex5_13_a;
extends Ex5_13_b;

//====================
//variable section
Real gamma(unit="dimensionless")"ratio of specific heat";
Real Tb(unit="K")"temperature taken from graph";
Real W3(unit="kJ/mol")"work done in the second condition";
Real delU1(unit="kJ/mol")"change in internal energy";

//====================
//equation section
equation
gamma=Cp/Cv;
Tb=(T1+273)*((P2/P1)^(gamma-1));
delU1=(Cv*((Tb-(T1+273))))/1000;
W3=-delU1;//Adiabatic compression
end Ex5_13_c;


end Ex5_13;
