//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.3
//Title:First law analysis of elementary process
//Calculate amount of heat interaction and work done by system
model Ex5_3

//parameter section
parameter Real P(unit="kPa")=100"pressure in which the saturated liquid water is contained";

//============
//variable section
Real hf(unit="kJ/kg")"enthapy of saturated liquid";
Real hg(unit="kJ/kg")"enthapy of saturated vapour";
Real vf(unit="m^3/kg")"specific volume of saturated liquid";
Real vg(unit="m^3/kg")"specific volume of saturated vapour";
Real W(unit="kJ")"work done by the system";
Real q(unit="kJ")"heat interacted by the system";

//==============
//equation section
equation
//Refer to appendix in book for steam tables in Pg no:443 for finding the values of hf,hg,vf,vg
hf=417.54;
hg=2675.4;
vf=0.001043;
vg=1.694;
W=(P*1000*(vg-vf))/1000;//Refer to book Pg no:112 for the equation of work done and the heat interacted
q=hg-hf;
end Ex5_3;
