//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.4
//Title:First law analysis of elementary process
//Calculate work done by ice and amount of energy transfered as heat during melting process
model Ex5_4

//===============
//parameter section
parameter Real roi(unit="kg/m^3")=916.23"density of ice";
parameter Real row(unit="kg/m^3")=999.8"density of water";
parameter Real P(unit="kPa")=100"pressure in which ice is melted to water";
parameter Real q(unit="kJ")=334.98"energy increased due to the pressure increased ";

//================
//variable section
Real vw(unit="m^3/kg")"volume of water";
Real vi(unit="m^3/kg")"volume of ice";
Real W(unit="kJ")"work done by the ice";
Real delU(unit="kJ")"energy transferred during the melting process";

//================
//equation section
equation
vw=1/row;//volume of water  Refer to book Pg no:113
vi=1/roi;//volume of ice
W=P*1000*(vw-vi);//work done
delU=q-(W*(10^(-3)));//amount of energy transferred
end Ex5_4;
