//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.6
//Title:First law analysis of elementary process
//Calculate heat and work interactions associated with compression process
model Ex5_6

//==============
//parameter section
parameter Real V1(unit="m^3/kmol")=30"initial volume of ammonia";
parameter Real V2(unit="m^3/kmol")=5"final volume of ammonia";
parameter Real T(unit="K")=300"Temperature of ammonia to compress isothermally";
parameter Real a(unit="Pa.(m^3/mol)^2")=422.546*10^(-3)"value of a in vander waals equation";
parameter Real b(unit="m^3/kmol")=0.037"value of b in vander waals equation";

//===========
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section

Real W(unit="kJ/kmol")"work done";
Real delU(unit="kJ/kmol")"change in internal energy";
Real Q(unit="kJ/kmol")"energy transferred as heat";

//=============
//equation section
equation
W=(R*T*log((V2-b)/((V1-b))))-(a*((1/(V1*10^(-3)))-(1/(V2*10^(-3)))));//Refer to book for the equation Pg no:116
delU=a*((1/V1)-(1/V2))*1000;
Q=delU+W;
end Ex5_6;
