//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 5:First law of thermodynamics
//Example:5.8
//Title:Adiabatic process
//Determine ﬁnal condition of steam and work done
model Ex5_8

//============
//parameter section
parameter Real P1(unit="MPa")=3"initial pressure of superheated steam";
parameter Real T1(unit="deg C")=500"initial temperature of the superheated steam";
parameter Real P2(unit="MPa")=100"finall pressure of superheated steam";

//============
//variable section
Real s1(unit="kJ/kg.K")"initial entropy of the steam";
Real u1(unit="kJ/kg")"initial internal energy of the steam";
Real h1(unit="kJ/kg")"initial specific enthalpy of the steam";
Real v1(unit="m^3/kg")"initial specific volume of the steam";
Real sf(unit="kJ/kg.K")"specific entropy of the steam in water state";
Real sg(unit="kJ/kg.K")"specific entropy of the steam in vapour";
Real X2(unit="dimensionless")"quality of the steam";
Real hf(unit="kJ/kg")"specific enthalpy of the steam in water state";
Real hg(unit="kJ/kg")"specific enthalpy of the steam in vapour state";
Real vf(unit="m^3/kg")"specific volume of the steam in water state";
Real vg(unit="m^3/kg")"specific volume of the steam in vapour state";
Real h2(unit="kJ/kg")"finall specific enthalpy of the steam";
Real u2(unit="kJ/kg")"final internal energy of the steam";
Real v2(unit="m^3/kg")"final specific volume of the steam";
Real W(unit="kJ/kg")"work done";

//====================
//equation section
equation
//Refer to steam table in appendix in book Pg no:448 for 30 bar and 500 deg C for the value of s1,v1,h1
s1=7.2345;
h1=3456.2;
v1=0.11608;
u1=((h1*1000)-(P1*10^6*v1))/1000;//divided by 1000 to convert to J to kJ
//Refer to steam table in appendix in book Pg no:443 for 1 bar for the value of sf,sg,hf,hg
sf=1.3027;
sg=7.3598;
hf=417.54;
hg=2675.4;
vf=0.0010434;
vg=1.694;
s1=(sg*X2)+((1-X2)*sf);//Refer to book Pg no:120 for the equation
h2=(hg*X2)+((1-X2)*hf);
v2=(vg*X2)+((1-X2)*vf);
u2=((h2*1000)-(P2*1000*v2))/1000;//divided by 1000 to convert J to kJ
W=u1-u2;
end Ex5_8;
