//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:First law analysis of process
//Example:6.1
//Title:constant volume analysis
//Estimate power output of turbine
model Ex6_1

parameter Real M(unit="kg/hr")=3600"mass flow rate of steam";
parameter Real Pe(unit="MPa")=0.2"Pressure of the steam entering";
parameter Real Te(unit="deg C")=400"Temperature of the steam entering";
parameter Real Pl(unit="MPa")=0.01"Pressure of the steam leaving";
parameter Real Vi(unit="m/s")=80"velocity at which the steam enters";
parameter Real Hi(unit="m")=10"height of the inlet to the turbine from the ground level";
parameter Real Ho(unit="m")=3"height of the outlet to the turbine from the ground level";
parameter Real Vo(unit="m/s")=150"velocity at which the steam leaves";
parameter Real Xe(unit="dimensionless")=0.05"quality of the staeam";
parameter Real Q(unit="MJ/h")=-36"energy loss as heat";

//==========================
//variable section
Real Ws(unit="kW")"power output of the turbine";
Real he(unit="kJ/kg")"total enthalpy of the steam";
Real hg(unit="kJ/kg")"total enthalpy of the steam in vapour state";
Real hf(unit="kJ/kg")"total enthalpy of the steam in liquid state";
Real hi(unit="kJ/kg")"enthalpy of the inlet steam";

//====================
//constant section
constant Real g(unit="m/s^2")=9.8"acceleration due to gravity";
//===================
//equation section
equation
//Refer to steam table in the appendix in book Pg no:443
hg=2584.8;
hf=191.83;
hi=3276.7;
he=(hg*(1-Xe))+(Xe*hf);//total enthalpy of the steam
((he*1000)+((Vo^2)/2)+(g*Ho))-((hi*1000)+((Vi^2)/2)+(g*Hi))=((Q*1000*1000/3600)-(Ws*1000))/(M/3600);
end Ex6_1;
