//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:case of an ideal gas
//Example:6.13
//Title:chemically reacting system
//Determine soichiometric air fuel ratio for comustion of C5H12 and composition of comustion products when C5H12 is burned with 150 prcent theoretical air
package Ex6_13

model Ex6_13_a

//C5H12+8O2+8(3.7619)N2------->5CO2+6H2O+30.095N2
//======================
//parameter section
parameter Real NN2(unit="mol")=30.095"moles of N2";
parameter Real NO2(unit="mol")=8"moles of O2";
parameter Real NC5H12(unit="moles")=1"moles of C5H12";
parameter Real MC5H12(unit="kg/mol")=72"molar mass of C5H12";
parameter Real Mair(unit="kg/mol")=28.97"molar mass of air";

//=======================
//variable section
Real Rm(unit="mol air/mol fuel")"air fuel ratio on mole basis";
Real R(unit="kg air/kg fuel")"air fuel ratio";

//==========================
//equation section
equation
Rm=(NO2+NN2)/NC5H12;//air fuel ratio on mole basis
R=Rm*Mair/MC5H12;//air fuel ratio
end Ex6_13_a;



//========================
model Ex6_13_b
//C5H12+(1.5*8)O2+(1.5*8*3.7619)N2-------------->5CO2+6H2O+45.14N2+4O2

//=====================
//parameter section
parameter Real NCO2(unit="mole")=5"number of moles of CO2";
parameter Real NH2O(unit="mole")=6"number of moles of H2O";
parameter Real NN2(unit="mole")=45.14"number of moles of N2";
parameter Real NO2(unit="mole")=4"number of moles of O2";

//=========================
//variable section
Real N(unit="moles")"total number of moles";
Real xCO2(unit="dimensionless")"mole fraction of CO2";
Real xH2O(unit="dimensionless")"mole fraction of H2O";
Real xN2(unit="dimensionless")"mole fraction of N2";
Real xO2(unit="dimensionless")"mole fraction of O2";

//========================
//equation section
equation
N=NCO2+NH2O+NN2+NO2;//Refer to book Pg no:177
xCO2=NCO2/N;
xH2O=NH2O/N;
xN2=NN2/N;
xO2=NO2/N;
end Ex6_13_b;


end Ex6_13;
