package Ex6_14
//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:chemically reacting systems
//Example:6.14
//Calculate product composition assuming complete combustion of fuel

model Ex6_14_a

//=========================
//parameter section
parameter Real xCO(unit="dimensionless")=0.26"mole fractions of CO";
parameter Real xH2(unit="dimensionless")=0.12"mole fractions of H2";
parameter Real xCO2(unit="dimensionless")=0.07"mole fractions of CO2";
parameter Real xN2(unit="dimensionless")=0.55"mole fractions of N2";
parameter Real NO2(unit="mol")=0.19"total moles of O2 required";
parameter Real NN2(unit="mol")=3.7619"moles of N2 required";

//0.26CO+0.13O2--------------->0.26CO2 refer to book Pg no:177 for equation
//0.12H2+0.06O2--------------->0.12H2O
//(0.26CO+0.12H2+0.07CO2+0.55N2)+(0.19O2+0.19*3.7619N2)------------->0.33CO2+0.12H2O+1.2468N2

//====================
//variable section
Real R(unit="mole air/mole fuel")"theoratical air fuel ratio";

//======================
//equation section
equation
R=NO2+(NO2*NN2);//theoratical air flow rate
end Ex6_14_a;

//=======================
model Ex6_14_b
extends Ex6_14_a;
//0.26CO+0.12H2+0.07CO2+0.55N2+1.2*0.19O2+1.2*0.19*3.7619N2-------->0.33CO2+0.12H2O+0.038O2+1.408N2  refer to book Pg no:178 for equation

//===================
//parameter section
parameter Real R1(unit="dimensionless")=1.2"excess amount of air fuel ratio used";

//===================
//variable section
Real NCO2(unit="moles")"number of moles of CO2";
Real NH2O(unit="moles")"number of moles of H2O";
Real N1O2(unit="moles")"number of moles of O2";
Real N1N2(unit="moles")"number of moles of N2";
Real Ni(unit="moles")"total number of moles";
Real yCO2(unit="dimensionless")"mole fraction of CO2";
Real yH2O(unit="dimensionless")"mole fraction of H2O";
Real yO2(unit="dimensionless")"mole fraction of O2";
Real yN2(unit="dimensionless")"mole fraction of N2";

//==================
//equation section
equation
NCO2=0.33;
NH2O=0.12;
N1O2=0.038;
N1N2=1.408;
Ni=NCO2+NH2O+N1O2+N1N2;
yCO2=NCO2/Ni;
yH2O=NH2O/Ni;
yO2=N1O2/Ni;
yN2=N1N2/Ni;
end Ex6_14_b;



end Ex6_14;
