//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:chemically reacting systems
//Example:6.15
//Determine actual air fuel ratio for the combustion process and excess air
model Ex6_15

//xC5H12+yO2+3.7619yN2--------->9.27CO2+2.31CO+zH2O+83.56N2  refer to boo Pg no:178 for equation
//====================
//parameter section
parameter Real CO2(unit="%")=9.27"amount of CO2 in resulting flue gas";
parameter Real CO(unit="%")=2.31"amount of CO in resulting flue gas";
parameter Real O2(unit="%")=4.86"amount of O2 in resulting flue gas";
parameter Real N2(unit="%")=83.56"amount of N2 in resulting flue gas";

//===================
//variable section
Real NN2(unit="dimensionless")"number of moles of N2";
Real NC(unit="dimensionless")"number of carbons in C5H12";
Real NH(unit="dimensionless")"number of hydrogens in C5H12";
Real y(unit="mol")"to balance nitrogen";
Real x(unit="mol")"to balance carbon";
Real z(unit="mol")"to balance hydrogen";
Real RA(unit="dimensionless")"actual air fuel ratio";
Real TR(unit="dimensionless")"theoratical air fuel ratio";
Real TA(unit="dimensionless")"%theoratical air required";
Real EA(unit="%")"percent excess air required";

//==============
//equation section
equation
NN2=3.76;//Refer to book Pg no:19
NC=5;
NH=12;
NN2*y=N2;
NC*x=CO2+CO;
NH*x=2*z;
RA=(y+N2)/x;
TR=38.095;
TA=(RA/TR)*100;
EA=TA-100;

end Ex6_15;
