//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:First law analysis of process
//chemically reacting systems
//Example:6.21
//Obtain general expression for standard heat of reaction using molar heat capacities of reactants
model Ex6_21

//5H12+8O2---------->5CO2+6H2O Refer to book for the stoichiometry equation
//==================
//parameter section
parameter Real delH298(unit="kJ")=-3274.5"standard heat of reaction at 298 K";//calculated from example 6_17
//value of a,b,c,d to vcalculate molar heat capacities are taken from appendix J in book Pg no:460 and 461
parameter Real a1(unit="dimensionless")=-3.26"value of a to calculate molar heat capcities";
parameter Real a2(unit="dimensionless")=28.11"value of a to calculate molar heat capcities";
parameter Real a3(unit="dimensionless")=19.8"value of a to calculate molar heat capcities";
parameter Real a4(unit="dimensionless")=32.24"value of a to calculate molar heat capcities";
parameter Real b1(unit="dimensionless")=48.73*10^(-2)"value of b to calculate molar heat capcities";
parameter Real b2(unit="dimensionless")=-3.68*10^(-6)"value of b to calculate molar heat capcities";
parameter Real b3(unit="dimensionless")=7.334*10^(-2)"value of b to calculate molar heat capcities";
parameter Real b4(unit="dimensionless")=0.1924*10^(-2)"value of b to calculate molar heat capcities";
parameter Real c1(unit="dimensionless")=-25.80*10^(-5)"value of c to calculate molar heat capcities";
parameter Real c2(unit="dimensionless")=1.746*10^(-5)"value of c to calculate molar heat capcities";
parameter Real c3(unit="dimensionless")=-5.602*10^(-5)"value of c to calculate molar heat capcities";
parameter Real c4(unit="dimensionless")=1.055*10^(-5)"value of c to calculate molar heat capcities";
parameter Real d1(unit="dimensionless")=5.305*10^(-8)"value of c to calculate molar heat capcities";
parameter Real d2(unit="dimensionless")=-1.065*10^(-8)"value of c to calculate molar heat capcities";
parameter Real d3(unit="dimensionless")=1.715*10^(-8)"value of c to calculate molar heat capcities";
parameter Real d4(unit="dimensionless")=-0.3596*10^(-8)"value of c to calculate molar heat capcities";
parameter Real T1(unit="K")=298"final temperature";
//=======================
//variable section
Real delH0(unit="kJ")"standard heat of reaction at 0 condition";
Real dela(unit="dimensionless")"to calculate del a";
Real delb(unit="dimensionless")"to calculate del b";
Real delc(unit="dimensionless")"to calculate del c";
Real deld(unit="dimensionless")"to calculate del d";

//========================
//equation section
equation
dela=(5*a3)+(6*a4)-a1-(8*a2);//refer to book Pg ni:190 for the equation
delb=(5*b3)+(6*b4)-b1-(8*b2);
delc=(5*c3)+(6*c4)-c1-(8*c2);
deld=(5*d3)+(6*d4)-d1-(8*d2);
delH298*10^3=(delH0*10^3)+(dela*T1)+((delb/2)*T1^2)+((delc/3)*T1^3)+((deld/4)*T1^4);
//equation as a function of themperature:delH0*1000+dela*T-(delb/2)*T^2+((delc/3)*T^3)+((deld/4)*T^4)
//Reamarks:value of dela is found to be 70.82 but in book given as 63.94 which is calculation error in book so the final answer also changes to -3290.08 
end Ex6_21;
