//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:Applications of throttling
//Example:6.5
//Determine minimum quality of wet steam at 20 bar
model Ex6_5

//===================
//parameter section
parameter Real P1(unit="bar")=1"exit pressure";
parameter Real P2(unit="bar")=20"pressure to be measured";
parameter Real T2(unit="deg C")=5"difference in temperature and saturation temperature";

//==========================
//variable section
Real hf(unit="kJ/kg")"enthalpy of the steam in liquid state";
Real hg(unit="kJ/kg")"enthalpy of the steam in vapour state";
Real he(unit="kJ/kg")"total enthalpy of the steam";
Real X(unit="dimensionless")"quality ofthe steam";

//================
//equation section
//Refer to steam tables in appendix for value of hf,hg,he and refer to book Pg no:156
equation
hf=908.59;
hg=2797.2;
he=2686.16;
he=(hg*X)+((1-X)*hf);//to find the quality of the steam
end Ex6_5;
