//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:Applications of throttling
//Example:6.6
//Determine the quality of wet steam
model Ex6_6
 
parameter Real P1(unit="bar")=30"pressure of the wet steam";
parameter Real P2(unit="bar")=1"pressure of the steam leaving";
parameter Real T2(unit="deg C")=105"temperaure of the steam leaving";
parameter Real mc(unit="g")=30"mass of condensate";
parameter Real m1(unit="kg")=1"mass of wet steam";

//==================
//variable section
Real h3(unit="kJ/kg")"enthalpy of the steam leaving";
Real hf(unit="kJ/kg")"enthalpy of the steam in liquid state";
Real hg(unit="kJ/kg")"enthalpy of the steam in vapour state";
Real X2(unit="dimensionless")"quality of steam";
Real X1(unit="dimensionless")"quality of wet steam";

//============
//equation section
equation
//Refer to book Pg no:157 for the values of h3,hf,hg
h3=2688.12;
hf=1008.4;
hg=2802.3;
h3=(X2*hg)+((1-X2)*hf);
X1=X2*(1-(mc/(1000*m1)));
end Ex6_6;
