//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:TRansient low process
//Example:6.7
//Determine temperature of air in cylinder at end of ﬁlling and mass of air ﬁlled in cylinder

model Ex6_7

//=============
//parameter section
parameter Real P(unit="bar")=50"pressure of the air flowing";
parameter Real T(unit="K")=300"Temperature of the air flowing";
parameter Real V(unit="m^3")=0.1"volume of the cylinder";
parameter Real gamma(unit="dimensionless")=1.4"Ratio of specific heat";
parameter Real Ma(unit="kg/kmol")=28.97"molar mass of air";

//====================
//constant section
constant Real R(unit="J/mol.K")=8.314"Value of gas constant";

//================
//variable section
Real Tf(unit="K")"final temperature value";
Real N(unit="mol")"number of moles";
Real M(unit="kg")"mass of air";

//=====================
//equation section
equation
Tf=gamma*T;
N=(P*10^5*V)/(R*Tf);//ideal gas law
M=N*Ma*10^(-3);//Mass of air filled in the cylinder Refer book Pg no:164
end Ex6_7;
