//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:Transient flow process
//Example:6.8
//Determine temperature of steam in tank at end of ﬁlling
model Ex6_8

//=========================
//parameter section
parameter Real P(unit="bar")=20"pressure of the steam flowing";
parameter Real T(unit="deg C")=500"temperature of the steam flowing";

//===============
//variable section
Real hi(unit="kJ/kg")"enthalpy of steam at 20 bar and 500 deg C";
Real uf(unit="kJ/kg")"entropy of steam at 20 bar and 500 deg C";
Real Tf(unit="deg C")"final temperature of the steam";
Real h1(unit="kJ/kg")"enthalpy of steam at 20 bar and 600 deg C";
Real v1(unit="m^3/kg")"specific volume of steam at 20 bar and 600 deg C";
Real u1(unit="kJ/kg")"entropy of steam at 20 bar and 600 deg C";
Real h2(unit="kJ/kg")"enthalpy of steam at 20 bar and 700 deg C";
Real v2(unit="m^3/kg")"specific volume of steam at 20 bar and 700 deg C";
Real u2(unit="kJ/kg")"entropy of steam at 20 bar and 700 deg C";
//Real u(unit="kJ/kg")"entropy of the steam in the final state";
Real T1(unit="deg C")"Temperature of the first assumed value";
Real T2(unit="deg C")"Temperature of the second assumed value";

//======================
//equation section
equation
//Refer to steam tables in the appendix in book Pg no:447 for the value o hi,uf,v1,h1,h2,v2
//Refer to book Pg no:164 for the values
hi=3467.3;
uf=3467.3;
T1=600;
T2=700;
h1=3689.2;
v1=0.1995;
h2=3916.5;
v2=0.2232;
u1=((h1*1000)-(P*10^5*v1))/1000;
u2=((h2*1000)-(P*10^5*v2))/1000;
(Tf-T1)/(T2-T1)=(uf-u1)/(u2-u1);//interpolation method to calculate final temperature
end Ex6_8;
