//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 6:Transient flow process
//Example:6.9
//Estimate mass of steam that enters the tank 

model Ex6_9

//====================
//parameter section
parameter Real V(unit="m^3")=2"volume of the tank";
parameter Real P1(unit="MPa")=1"pressure of the steam";
parameter Real P2(unit="MPa")=4"pressure of the steam when pipe is connected";
parameter Real T2(unit="deg C")=400"temperature of the steam when pipe is connected";

//=====================
//variable section
Real v0(unit="m^3/kg")"specific volume of the steam at initial condition";
Real u0(unit="kJ/kg")"entropy of the steam at initial condition";
Real m0(unit="kg")"initial mass of the steam";
Real Tf(unit="deg C")"final temperature of the steam";
Real hf(unit="kJ/kg")"final enthalpy of the steam";
Real vf(unit="m^3/kg")"final specific volume of the steam";
Real mf(unit="kg")"final mass of the steam";
Real hi(unit="kJ/kg")"enthalpy of the steam after valve is open";
Real delM(unit="kg")"difference in mass";
Real h0(unit="kJ/kg")"enthalpy of the steam";
Real uf(unit="kJ/kg")"final entropy of the steam";

//==================
//equation section
equation
//Refer to steam tables in the appendix in book 
//refer to book Pg no:165 for the values of hf and vf
Tf=425;
h0=2776.2;
v0=0.1943;
u0=h0-(P1*1000*v0);
m0=V/v0;
hi=3215.7;
hf=3273.03;
vf=0.0766;
uf=hf-(P2*1000*vf);
mf=V/vf;
delM=mf-m0;  //mf*(hi-vf)=m0*(hi-uf);

end Ex6_9;
