//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.10
//Title:Calculation of entropy change
//Determine entropy change of air
model Ex7_10

//===============
//parameter section
parameter Real T1(unit="K")=300"initial temperature of the vessel";
parameter Real T2(unit="K")=370"final temperature of the vessel";
parameter Real gamma(unit="gamma")=1.4"Ratio of specific heat";

//=================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//=================
//variable section
Real Cv(unit="J/mol.K")"specific heat of specific volume";
Real delS(unit="J/mol.K")"change in entropy";

//=================
//equation section
equation
Cv=R/(gamma-1);
delS=Cv*log(T2/T1);
end Ex7_10;
