//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.12
//Title:Calculation of entropy change
//Estimate entropy change of steel and oil and system consisting of oil and lump of steel
model Ex7_12

//=================
//parameter section
parameter Real T1(unit="deg C")=427"Temperature of the steel";
parameter Real M1(unit="kg")=30"mass of steel";
parameter Real M2(unit="kg")=150"mass of oil";
parameter Real T2(unit="deg C")=27"Temperature of oil";
parameter Real Cp1(unit="kJ/kg.K")=0.46"specific heat of steel";
parameter Real Cp2(unit="kJ/kg.K")=2.5"specific heat of oil";

//================
//variable section
Real T(unit="K")"final temperature of oil and steel";
Real delSs(unit="kJ/K")"change in entropy of steel";
Real delSo(unit="kJ/K")"change in entropy of oil";
Real delS(unit="kJ/K")"Total change in entrpy";

//================
//equation section
equation
M1*Cp1*((T1+273)-T)=M2*Cp2*(T-(T2+273));//To calculate final temperature
delSs=M1*Cp1*log(T/(T1+273));
delSo=M2*Cp2*log(T/(T2+273));
delS=delSs+delSo;
end Ex7_12;
