//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.13
//Title:Calculation of entropy change
//Determine entropy change for given conditions

model Ex7_13

//=================
//parameter section
parameter Real P1(unit="bar")=1"initial state pressure";
parameter Real P2(unit="bar")=2"final state pressure";
parameter Real T1(unit="K")=300"initial state temperature";
parameter Real T2(unit="K")=500"final state temperature";
parameter Real Cp(unit="J/mol.K")=7*R/2"specific at constant pressure";

//=================
//constant section
constant Real R(unit="J/mol.K")=8.314"gas constant";

//================
//variable section
Real delS(unit="kJ/kmol.K")"entropy change";

//===============
//equation section
equation
delS=(Cp*log(T2/T1))-(R*log(P2/P1));//to calculate change in entropy
end Ex7_13;
