//=============//Y.V.C Rao,An INTRODUCTION TO THERMODYNAMICS,SECOND EDITION,2004

//Chapter 7:Second law of thermodynamics
//Example:7.16
//Title:Temperature entropy diagram
//Calculate work done by steam
model Ex7_16

//===============
//parameter section
parameter Real P1(unit="MPa")=1"Pressure of superheated steam";
parameter Real T1(unit="deg C")=300"Temperature of superheated steam";
parameter Real P2(unit="kPa")=100"adiabatic expansion pressure";

//===============
//variable section
Real h1(unit="kJ/kg")"enthalpy of superheated steam";
Real v1(unit="m^3/kg")"specific volume of superheated steam";
Real s1(unit="kJ/kg.K")"entropy of superheated steam";
Real u1(unit="kJ/kg")"internal energy of superheate steam";
Real sf(unit="kJ/kg.K")"entropy in liquid state";
Real sg(unit="kJ/kg.K")"entropy in vapour state";
Real hf(unit="kJ.kg")"enthalpy in liquid state";
Real hg(unit="kJ/kg.K")"enthalpy in vapour state";
Real vf(unit="m^3/kg")"specific volume in liquid state";
Real vg(unit="m^3/kg")"specific volume in vapour state";
Real X2(unit="dimensionless")"quality of the steam";
Real h2(unit="kJ/kg")"enthalpy in the second condition";
Real v2(unit="m^3/kg")"specific volume in the second condition";
Real u2(unit="kJ/kg")"internal energy in the second condition";
Real W(unit="kJ/kg")"work done by the steam";

//===============
//equation section
//Refer to book Pg no:255 for the values of h1,v1,s1,sf,sg,vf,vg,hf,hg
equation
h1=3052.1;
v1=0.2580;
s1=7.1251;
u1=h1-(P1*10^3*v1);
sf=1.3027;
sg=7.3598;
hf=417.54;
hg=2675.4;
vf=0.001043;
vg=1.6940;
s1=(sg*X2)+((1-X2)*sf);
h2=(hg*X2)+((1-X2)*hf);
v2=(vg*X2)+((1-X2)*vf);
u2=h2-(P2*v2);
W=u1-u2;
end Ex7_16;
